// Ferry.js //

// To keep track of the ferries on the map //
var Ferries = [];

// The ferry object for ferrying Ball around the map
function Ferry()
{
	this.name = GetCurrentPerson();
	this.finished = false; // for end of path.
	this.full = false;
	this.move = false;
}

Ferry.prototype.ferry = function(tiles)
{
	var X = GetPersonX(this.name);
	var Y = GetPersonY(this.name);
	var D = GetPersonDirection(this.name);
	
	// Check to see if player stepped within the ferry zone
	if (Player.x > X-15 && Player.y > Y-15 && Player.x < X+16 && Player.y < Y+16) {
		if (!Player.jumping) {
			if (!this.full) this.move = true;
			this.full = true;
		}
	}
	else this.full = this.finished = false;
	
	// Stop control; do movement
	if (this.move && IsCommandQueueEmpty(Player.name)) {
		TileMovement.pauseEngine();
		SetPersonSpriteset(Player.name, LoadSpriteset('BallStill.rss'));
		SetPersonSpeed(Player.name, 2);
		SetPersonSpeed(this.name, 2);
		for (var i = 0, total = tiles*16; i < total; ++i) {
			switch (D)
			{
				case "north":
					QueuePersonCommand(this.name, COMMAND_MOVE_NORTH, false);
					QueuePersonCommand(Player.name, COMMAND_MOVE_NORTH, false);
				break;
				case "south":
					QueuePersonCommand(this.name, COMMAND_MOVE_SOUTH, false);
					QueuePersonCommand(Player.name, COMMAND_MOVE_SOUTH, false);
				break;
				case  "east":
					QueuePersonCommand(this.name, COMMAND_MOVE_EAST , false);
					QueuePersonCommand(Player.name, COMMAND_MOVE_EAST , false);
				break;
				case  "west":
					QueuePersonCommand(this.name, COMMAND_MOVE_WEST , false);
					QueuePersonCommand(Player.name, COMMAND_MOVE_WEST , false);
				break;
			}
		}
		this.move = false;
	}
	
	// Check to see if movement has completed
	if (IsCommandQueueEmpty(this.name) && this.full && !this.move) {
		if (!this.finished) {
			TileMovement.unpauseEngine();
			SetPersonSpriteset(Player.name, LoadSpriteset('Ball.rss'));
			switch (D) {
					case "north": SetPersonDirection(this.name, "south"); break;
					case "north": SetPersonDirection(this.name, "north"); break;
					case  "east": SetPersonDirection(this.name,  "west"); break;
					case  "west": SetPersonDirection(this.name,  "east"); break;
			}
			this.finished = true;
		}
	}
}